"""Service for managing application settings stored in TinyDB."""

from __future__ import annotations

from typing import Optional

from ca_task_manager.repositories.settings_repo import SettingsRepository
from ca_task_manager.models.settings import Settings


class SettingsService:
    def __init__(self, repo: Optional[SettingsRepository] = None):
        self.repo = repo or SettingsRepository()

    def get_settings(self) -> Settings:
        return self.repo.get_settings()

    def update_settings(self, look_ahead_days: int, timezone: str) -> None:
        current = self.repo.get_settings()
        updated = Settings(id=current.id, look_ahead_days=look_ahead_days, timezone=timezone)
        self.repo.update_settings(updated)